# 機能設計書 51-VCL プロバイダー

## 概要

本ドキュメントは、Horse WebフレームワークにおけるVCL（Visual Component Library）プロバイダー機能の設計を記述する。

### 本機能の処理概要

VCL プロバイダーは、Delphi VCLアプリケーション内でHTTPサーバーを動作させるための機能を提供する。Windows GUIアプリケーションのコンテキスト内でWebサービスを実行し、フォーム上のボタン操作でサーバーの起動・停止を制御できる。

**業務上の目的・背景**：デスクトップアプリケーション開発において、既存のVCLアプリケーションにRESTful APIやWebサービス機能を追加する需要がある。VCL プロバイダーにより、独立したサーバープロセスを起動することなく、GUIアプリケーション内でHTTPサーバーを統合的に運用できる。これにより、ローカルサービスの提供やデスクトップ連携APIの構築が容易になる。

**機能の利用シーン**：
- デスクトップアプリケーションにローカルAPIエンドポイントを追加したい場合
- 他のアプリケーションやブラウザからデスクトップアプリケーションの機能を呼び出したい場合
- GUIを持つ管理ツールでHTTPサーバーの状態を視覚的に監視・制御したい場合
- 開発・テスト用のローカルサーバーをGUI付きで起動したい場合

**主要な処理内容**：
1. TIdHTTPWebBrokerBridgeを使用したHTTPサーバーインスタンスの生成と管理
2. ホスト・ポート・最大接続数・キープアライブ等のサーバー設定
3. SSL/TLS暗号化通信のサポート（OpenSSLを使用）
4. サーバーの起動（Listen）と停止（StopListen）処理
5. 起動・停止時のコールバック処理の実行
6. サーバー実行状態（IsRunning）の監視機能

**関連システム・外部連携**：
- Indy（TIdHTTPWebBrokerBridge）ライブラリによるHTTP通信基盤
- OpenSSL ライブラリによるSSL/TLS暗号化
- WebBroker アーキテクチャによるリクエスト処理

**権限による制御**：VCL プロバイダー自体には権限制御機能はなく、HTTPサーバーとしてリクエストを受け付ける。認証・認可はミドルウェアやルートハンドラで実装する必要がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | VCLメインフォーム | 主画面 | Startボタンでサーバー起動、Stopボタンで停止、ポート番号入力 |
| 2 | VCL-SSLメインフォーム | 参照画面 | SSL/TLS設定を含むサーバー起動 |

## 機能種別

サーバー管理 / HTTP通信基盤

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Port | Integer | No | リスニングポート番号 | 0より大きい整数、デフォルト9000 |
| Host | string | No | バインドするホスト | 空文字列の場合は'0.0.0.0'、Trim処理される |
| MaxConnections | Integer | No | 最大同時接続数 | 0より大きい場合に設定 |
| ListenQueue | Integer | No | リッスンキューサイズ | 0の場合IdListenQueueDefault使用 |
| KeepConnectionAlive | Boolean | No | キープアライブ設定 | デフォルトTrue |
| IOHandleSSL | IHorseProviderIOHandleSSL | No | SSL/TLS設定 | nilの場合SSL無効 |
| CallbackListen | TProc | No | 起動時コールバック | - |
| CallbackStopListen | TProc | No | 停止時コールバック | - |

### 入力データソース

- プログラムからのプロパティ設定
- Listen メソッドの引数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| IsRunning | Boolean | サーバーの実行状態 |

### 出力先

- Boolean戻り値によるサーバー状態の返却
- コールバック関数の実行

## 処理フロー

### 処理シーケンス

```
1. Listen メソッド呼び出し
   └─ InternalListen を呼び出す
2. デフォルト値の設定
   └─ Port が 0以下なら DEFAULT_PORT(9000) を設定
   └─ Host が空なら DEFAULT_HOST('0.0.0.0') を設定
3. HTTPサーバーインスタンスの取得または生成
   └─ GetDefaultHTTPWebBroker で TIdHTTPWebBrokerBridge を取得
4. WebModuleClass の設定
   └─ THorseWebModule を WebRequestHandler に設定
5. サーバー設定の適用
   └─ MaxConnections の設定
   └─ ListenQueue の設定
   └─ SSL/TLS 設定（IOHandleSSL が設定されている場合）
   └─ Bindings の設定（Host が指定されている場合）
   └─ KeepAlive の設定
6. サーバー起動
   └─ Active を True に設定
   └─ StartListening 呼び出し
7. コールバック実行
   └─ FRunning を True に設定
   └─ DoOnListen でコールバック実行
```

### フローチャート

```mermaid
flowchart TD
    A[Listen 呼び出し] --> B{Port 設定済み?}
    B -->|No| C[DEFAULT_PORT 設定]
    B -->|Yes| D{Host 設定済み?}
    C --> D
    D -->|No| E[DEFAULT_HOST 設定]
    D -->|Yes| F[HTTPWebBroker 取得]
    E --> F
    F --> G[WebModuleClass 設定]
    G --> H{MaxConnections > 0?}
    H -->|Yes| I[MaxConnections 設定]
    H -->|No| J{SSL設定あり?}
    I --> J
    J -->|Yes| K[SSL IOHandler 初期化]
    J -->|No| L[Bindings 設定]
    K --> L
    L --> M[KeepAlive 設定]
    M --> N[DefaultPort 設定]
    N --> O[Active = True]
    O --> P[StartListening]
    P --> Q[FRunning = True]
    Q --> R[DoOnListen]
    R --> S[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-51-01 | デフォルトポート | ポート未指定時は9000を使用 | Port が 0以下の場合 |
| BR-51-02 | デフォルトホスト | ホスト未指定時は'0.0.0.0'（全インターフェース）を使用 | Host が空文字列の場合 |
| BR-51-03 | キープアライブ初期値 | 初期化時にKeepConnectionAliveをTrueに設定 | ユニット初期化時 |
| BR-51-04 | SSL判定 | IOHandleSSL が nil でなく Active が True の場合にSSL使用 | OnQuerySSLPort イベント発生時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Exception | StopListen時にHTTPWebBrokerが未生成 | 'Horse not listen' メッセージで例外発生 |
| - | Exception | サーバー起動失敗（ポート使用中等） | 例外を再スロー |

### リトライ仕様

リトライ機能は実装されていない。ポート競合等の場合はアプリケーション側で対処が必要。

## トランザクション仕様

HTTPサーバーとして動作するため、データベーストランザクションは本機能では管理しない。

## パフォーマンス要件

- MaxConnections でリソース制限が可能
- ListenQueue でバックログキューサイズを調整可能
- KeepConnectionAlive で持続的接続によるオーバーヘッド軽減

## セキュリティ考慮事項

- IOHandleSSL プロパティでSSL/TLS暗号化を有効化可能
- 証明書ファイル（CertFile, KeyFile, RootCertFile）の適切な管理が必要
- OnGetPassword イベントで秘密鍵のパスワードを安全に提供
- OnParseAuthentication イベントで認証情報の処理が可能（VHandled=Trueで処理済みとマーク）

## 備考

- HORSE_VCL コンパイルディレクティブが定義されている必要がある
- Indy（TIdHTTPWebBrokerBridge）が依存関係として必要
- SSL/TLS使用時はOpenSSLライブラリが必要

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

VCL プロバイダーの設定に使用されるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Constants.pas | `src/Horse.Constants.pas` | DEFAULT_HOST, DEFAULT_PORT, START_RUNNING などの定数定義 |
| 1-2 | Horse.Provider.IOHandleSSL.Contract.pas | `src/Horse.Provider.IOHandleSSL.Contract.pas` | IHorseProviderIOHandleSSL インターフェース定義 |
| 1-3 | Horse.Provider.IOHandleSSL.pas | `src/Horse.Provider.IOHandleSSL.pas` | SSL/TLS設定クラスの実装 |

**読解のコツ**: Delphiのクラス変数（class var）は静的メンバーとして機能し、インスタンス間で共有される。THorseProviderではFPort, FHost, FRunning等がクラス変数として定義されている。

#### Step 2: 抽象プロバイダーを理解する

全プロバイダーの基底クラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Provider.Abstract.pas | `src/Horse.Provider.Abstract.pas` | THorseProviderAbstract クラスの定義、OnListen/OnStopListen コールバック管理 |

**主要処理フロー**:
- **39-43行目**: DoOnListen - 起動時コールバックの実行
- **45-49行目**: DoOnStopListen - 停止時コールバックの実行
- **71-74行目**: StopListen - デフォルト実装は例外をスロー

#### Step 3: VCL プロバイダー本体を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Provider.VCL.pas | `src/Horse.Provider.VCL.pas` | THorseProvider クラスの実装 |

**主要処理フロー**:
- **19-66行目**: THorseProvider クラス定義（class var, プロパティ, メソッド）
- **82-91行目**: GetDefaultHTTPWebBroker - HTTPサーバーインスタンスのシングルトン取得
- **108-111行目**: OnQuerySSLPort - SSL使用判定
- **155-167行目**: InitServerIOHandlerSSLOpenSSL - SSL/TLSハンドラーの初期化
- **169-213行目**: InternalListen - サーバー起動の核心処理
- **215-226行目**: InternalStopListen - サーバー停止処理
- **262-265行目**: OnAuthentication - 認証イベントハンドラ（VHandled=Trueで処理済みマーク）
- **292-295行目**: UnInitialize - クラスデストラクタでリソース解放
- **297-298行目**: initialization - 初期化セクションでKeepConnectionAliveをTrueに設定

#### Step 4: WebModuleを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Horse.WebModule.pas | `src/Horse.WebModule.pas` | THorseWebModule クラス、リクエスト処理の委譲 |

**主要処理フロー**:
- **69-78行目**: Create コンストラクタ - THorseCoreインスタンスの取得
- **87-110行目**: HandlerAction - リクエスト・レスポンスの生成とルート実行

#### Step 5: 使用例を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | Main.Form.pas | `samples/delphi/vcl/src/Main.Form.pas` | VCL アプリケーションでの使用例 |

**主要処理フロー**:
- **39-45行目**: FormCreate - ルート登録
- **48-52行目**: Start - THorse.Listen呼び出し
- **61-64行目**: Stop - THorse.StopListen呼び出し
- **54-59行目**: Status - IsRunningでUI状態更新

### プログラム呼び出し階層図

```
THorse (Horse.pas)
    │
    └─ THorseProvider (Horse.Provider.VCL.pas)
           │
           ├─ Listen()
           │      └─ InternalListen()
           │             ├─ GetDefaultHTTPWebBroker()
           │             │      └─ TIdHTTPWebBrokerBridge.Create()
           │             ├─ WebRequestHandler.WebModuleClass := WebModuleClass
           │             │      └─ THorseWebModule (Horse.WebModule.pas)
           │             ├─ InitServerIOHandlerSSLOpenSSL() [if SSL enabled]
           │             │      └─ TIdServerIOHandlerSSLOpenSSL.Create()
           │             └─ DoOnListen()
           │
           ├─ StopListen()
           │      └─ InternalStopListen()
           │             ├─ GetDefaultHTTPWebBroker().Active := False
           │             ├─ DoOnStopListen()
           │             └─ StopListening()
           │
           └─ IsRunning
                  └─ FRunning 参照
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Host/Port/               ┌─────────────────────────┐
MaxConnections  ───────▶ │   THorseProvider        │
IOHandleSSL              │   (設定保持)            │
                         └───────────┬─────────────┘
                                     │
                                     ▼
                         ┌─────────────────────────┐
  Listen()       ───────▶│ TIdHTTPWebBrokerBridge  │───────▶ FRunning = True
  コールバック           │ (HTTPサーバー)          │         DoOnListen()
                         └───────────┬─────────────┘
                                     │
                                     ▼
                         ┌─────────────────────────┐
  HTTPリクエスト ───────▶│   THorseWebModule       │───────▶ HTTPレスポンス
                         │ (リクエスト処理委譲)   │
                         └───────────┬─────────────┘
                                     │
                                     ▼
                         ┌─────────────────────────┐
  StopListen()   ───────▶│   サーバー停止処理      │───────▶ FRunning = False
                         │                         │         DoOnStopListen()
                         └─────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.pas | `src/Horse.pas` | ソース | メインユニット、コンパイルディレクティブによるプロバイダー選択 |
| Horse.Provider.VCL.pas | `src/Horse.Provider.VCL.pas` | ソース | VCL プロバイダー実装 |
| Horse.Provider.Abstract.pas | `src/Horse.Provider.Abstract.pas` | ソース | プロバイダー抽象基底クラス |
| Horse.Provider.IOHandleSSL.pas | `src/Horse.Provider.IOHandleSSL.pas` | ソース | SSL/TLS設定実装 |
| Horse.Provider.IOHandleSSL.Contract.pas | `src/Horse.Provider.IOHandleSSL.Contract.pas` | ソース | SSL/TLS設定インターフェース |
| Horse.Constants.pas | `src/Horse.Constants.pas` | ソース | 定数定義 |
| Horse.WebModule.pas | `src/Horse.WebModule.pas` | ソース | WebModuleクラス |
| Horse.Core.pas | `src/Horse.Core.pas` | ソース | コア機能（ルーティング等） |
| Main.Form.pas | `samples/delphi/vcl/src/Main.Form.pas` | サンプル | VCL使用例 |
| Main.Form.pas | `samples/delphi/vcl-ssl/src/Main.Form.pas` | サンプル | VCL SSL使用例 |
| VCL.dpr | `samples/delphi/vcl/VCL.dpr` | プロジェクト | VCLサンプルプロジェクト |
